
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Exercise : PI.GM.N610.ELearning.BL.DBD.Exercise
    {
        #region Static factory
        private static Exercise _factory = null;

        public static new Exercise DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Exercise();
                }
                return _factory;
            }
        }
        #endregion

        #region Extended Commands definition
        public enum ExtendedCommands
        {
            RestoreNextExerciseForExerciseWeightUnitIDDifficulty                = 101,
            RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty      = 102,
            RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight = 103,
            RestoreFirstExerciseForUnitIDDifficulty                             = 104,
            RestoreRandomExerciseForUserIDUnitIDDifficulty                      = 105,
            CountExercisesPositionByDifficulty                                  = 106,
            CountExercisesByDifficulty                                          = 107
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)ExtendedCommands.RestoreNextExerciseForExerciseWeightUnitIDDifficulty                 : return new Command_RestoreNextExerciseForExerciseWeightUnitIDDifficulty();
                case (int)ExtendedCommands.RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty       : return new Command_RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty();
                case (int)ExtendedCommands.RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight  : return new Command_RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight();
                case (int)ExtendedCommands.RestoreFirstExerciseForUnitIDDifficulty                              : return new Command_RestoreFirstExerciseForUnitIDDifficulty();
                case (int)ExtendedCommands.RestoreRandomExerciseForUserIDUnitIDDifficulty                       : return new Command_RestoreRandomExerciseForUserIDUnitIDDifficulty();
                case (int)ExtendedCommands.CountExercisesPositionByDifficulty                                   : return new Command_CountExercisesPositionByDifficulty();
                case (int)ExtendedCommands.CountExercisesByDifficulty                                           : return new Command_CountExercisesByDifficulty();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreNextExerciseForExerciseWeightUnitIDDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Exercise>
        {
            public Command_RestoreNextExerciseForExerciseWeightUnitIDDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("UnitID"           , Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ExerciseID"       , Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID"    , Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID"   , Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_RestoreNextExerciseForExerciseWeightUnitIDDifficulty";
            }
        }

        class Command_RestoreRandomExerciseForUserIDUnitIDDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Exercise>
        {
            public Command_RestoreRandomExerciseForUserIDUnitIDDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_RestoreRandomExerciseForUserIDUnitIDDifficulty";
            }
        }

        class Command_RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Exercise>
        {
            public Command_RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_RestoreFirstExerciseForStatisticCourseIDUnitIDUserIDDifficulty";            
            }
        }

        class Command_RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Exercise>
        {
            public Command_RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight() : base(PI.ZB.N1200.ELearning.BL.DBD.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_RestoreRepeatNextExerciseForUnitIDUserIDDifficultyOrderByLoopWeight";
            }
        }

        class Command_RestoreFirstExerciseForUnitIDDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Exercise>
        {
            public Command_RestoreFirstExerciseForUnitIDDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Exercise.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_RestoreFirstExerciseForUnitIDDifficulty";
            }
        }

        class Command_CountExercisesPositionByDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public Command_CountExercisesPositionByDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ExerciseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_CountExercisePositionByDifficulty";
            }
        }

        class Command_CountExercisesByDifficulty : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public Command_CountExercisesByDifficulty() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Exercise_CountExerciseByDifficulty";
            }
        }
        #endregion
    }
}